#pragma once
#ifndef SDLSOUND_H_
#define SDLSOUND_H_

#include <XFaceApp/ISound.h>

#include <SDL.h>

namespace XFaceApp
{
	class SDLSound : public ISound
	{
		static bool s_bMute;
		static Uint8 *s_audio_chunk;
		Uint32 m_audio_len;
		static Uint32 s_audio_remains;
		static Uint8 *s_audio_pos;
		static void playSound(void *udata, Uint8 *stream, int len);
	public:
		void jump(float percentage);
		bool loadWAV(const std::string& filename);
		void mute(bool bMute);
		void play();
		void pause();
		void stop();
		void unload();
		
		SDLSound(void);
		~SDLSound(void);
	};
} // namespace XFaceApp

#endif // SDLSOUND_H_